/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */    
package com.ejie.p06b.log;

import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;


/**
 * Clase que define la salida del Log en un fichero definido en la configuracion de la aplicacion.
 */  
public class P06BFileLog implements P06BILog
{
	String fileName;

    /**
     * Constructor vacio
     */	
	public P06BFileLog()
	{
		java.util.Date fechaHoy = new java.util.Date();
		try{
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
	   		String anio = simpleDateFormat.format(fechaHoy);
	   		SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("M");
	   		String mes = simpleDateFormat2.format(fechaHoy);
			fileName = P06BParametros.get("log.logfile") + "salida" + anio + "-" + mes + ".txt";
		}catch(Exception e){
			fileName = P06BParametros.get("log.logfile") + "salidaMalGenerada.txt";
			P06BLog.send(2,this.getClass().getName(),"Error obteniendo fecha de nombre de fichero de salida: " + e.toString());
		}
		
	}

    /**
     * Constructor
     *
     * @param fileName  nombre del fichero
     */		
	public P06BFileLog(String fileName)
	{
		this.fileName = fileName;
	}
	
    /**
     * Construye el mensaje y lo escribe en el fichero
     *
     * @param perfil    perfil del usuario
     * @param src       el objeto que gener el mensaje
     * @param message   el texto a mostrar
     */	    
	public void lanza(P06BPerfilUsuario perfil, Object src, String message)
	{
		String mes="";

    Object[] parametros = {
        new Date(System.currentTimeMillis()),
        src.toString(),
        message,perfil.getIdUsuario() };
    try {
        mes = MessageFormat.format("[{1}][{0}]\"{2}\"",parametros);
    }
    
    catch (Exception e) {
        P06BLog.send(2,"mensaje", "ERROR DE CONSOLA");
    }     

    escribe( src, mes );
  }
	
    /**
     * Construye el mensaje y lo escribe en el fichero
     *
     * @param perfil    perfil del usuario
     * @param message   el texto a mostrar
     */	      
  public void lanza(Object src, String message)
  {
    String mes;

    Object[] parametros = {
        new Date(System.currentTimeMillis()),
        src.toString(),
        message };
                        
    mes = MessageFormat.format("[{1}][{0}]\"{2}\"",parametros);

    escribe( src, mes );
  }

	
    /**
     * Escribe el mensaje en un fichero
     *
     * @param src       objeto que genero el mensaje
     * @param message   el texto a mostrar
     */
  private synchronized void escribe( Object src, String mensaje ) {
		try
		{
			RandomAccessFile file = new RandomAccessFile(fileName,"rw");
			file.seek(file.length());
			file.writeBytes(mensaje + '\n');
			file.close();
		}
		catch (Exception e)
		{
			altLog(src,mensaje,e);
		}
		
	}
	
	private void altLog(Object src, String message, Exception e)
	{
		System.out.println( src.toString() + "|LOG ERROR:" + this + "[" + message + "]");
	}

}